#include <windows.h>
#include "stdlib.h"
#include "options.h"
#include "switches.h"

void OptRead( char* Str, OPTLIST* Options )
  {
    int   i, Count;
    char  Opt, Ch;
    char  *Buf, *OptBegin, *OptEnd;

    Buf = (char*) LocalAlloc( LMEM_FIXED, lstrlen( Str ) + 16 );
    if( Buf == NULL ) return;

    // first, determine option count and init OptBegin and OptEnd

    for( Count = 0; Options[ Count ].Option != '\0'; Count++ ) {
      Options[ Count ].OptBegin = NULL;
      Options[ Count ].OptEnd = NULL;
    }

    // parse Str

    for(;;) {
      while( *Str == ' ' ) Str++;
      if( *Str == '\0' ) break;
      if( *(Str + 1) != '=' ) {
        Str++; if( *Str == '\0' ) break;
      }
      else {
        Opt = *Str;
        OptBegin = Str;

        // string may be quoted or not

        Str += 2;
        if( *Str == '"' )    // quoted
          for( i = 1;; ) {         // copy string, replacing double quotes
            Ch = Str[i];
            Buf[i-1] = Ch;
            if( Ch == '\0' ) break;
            if( Ch != '"' )
              i++;
            else
              if( Str[ i + 1 ] == '"' ) i += 2;
              else {
                Buf[i-1] = '\0';
                i++;
                break;
              }
          }
        else
          for( i = 0;; ) {
            Ch = Str[i];
            Buf[i] = Ch;
            if( Ch == '\0' || Ch == ' ' ) break;
            i++;
          }
        Str += i;
        OptEnd = Str;

        for( i = 0; i < Count; i++ ) if( Options[i].Option == Opt ) break;
        if( i < Count ) {
          Options[i].OptBegin = OptBegin;
          Options[i].OptEnd = OptEnd;
          switch( Options[i].Type ) {
            case OPT_ULONG:
              *((ULONG*) (Options[i].Buffer)) = Strtoul( Buf, NULL, 0 );
              break;
            case OPT_STR:
              lstrcpyn( (char*)(Options[i].Buffer), Buf, Options[i].BufferSz );
              break;
          }
        }
      }
    }
    LocalFree( Buf );
  }
